using System;
using System.Runtime.InteropServices;
using System.Security.Permissions;
using Microsoft.SharePoint;

namespace Code6587EN.Ch04.Features.SiteBranding
{
    [Guid("7767e722-e2f2-42e6-8ff5-79c8e78628e8")]
    public class SiteBrandingEventReceiver : SPFeatureReceiver
    {
        private const string PropertyOldMasterUrl = "CustomProp::OldMasterUrl";
        private const string PropertyOldCustomMasterUrl = "CustomProp::OldCustomMasterUrl";
        private const string TacomaMasterUrl = "_catalogs/masterpage/Tacoma.master";
        private const string SeattleMasterUrl = "_catalogs/masterpage/Seattle.master";

        public override void FeatureActivated(SPFeatureReceiverProperties properties)
        {
            // Get the SharePoint Site the feature was activated on
            using (var web = properties.Feature.Parent as SPWeb)
            {
                // Ensure the SharePoint Site is not null
                if (web != null)
                {
                    // Get current state of AllowUnsafeUpdates for the Site
                    var allowUnsafeUpdates = web.AllowUnsafeUpdates;
                    
                    // Set AllowUnsafeUpdates
                    web.AllowUnsafeUpdates = true;
                    web.Update();

                    // Remove our custom properties to store the old Master Page Urls if they exist
                    if (web.AllProperties.ContainsKey(PropertyOldMasterUrl))
                        web.AllProperties.Remove(PropertyOldMasterUrl);

                    if (web.AllProperties.ContainsKey(PropertyOldCustomMasterUrl))
                        web.AllProperties.Remove(PropertyOldCustomMasterUrl);

                    // Get existing Master Page Urls
                    var masterUrl = web.MasterUrl;
                    var customMasterUrl = web.CustomMasterUrl;

                    // Save the existing Master Page Url values as properties to allow us to revert 
                    // when feature is deactivated
                    web.AllProperties.Add(PropertyOldMasterUrl, masterUrl);
                    web.AllProperties.Add(PropertyOldCustomMasterUrl, customMasterUrl);

                    // Set the Tacoma master page as the Site and System Master Pages
                    web.MasterUrl = TacomaMasterUrl;
                    web.CustomMasterUrl = TacomaMasterUrl;
                    web.Update();

                    // Revert AllowUnsafeUpdates
                    web.AllowUnsafeUpdates = allowUnsafeUpdates;
                    web.Update();
                }
            }
        }

        public override void FeatureDeactivating(SPFeatureReceiverProperties properties)
        {
            // Get the SharePoint Site the feature was activated on
            using (var web = properties.Feature.Parent as SPWeb)
            {
                // Ensure the SharePoint Site is not null
                if (web != null)
                {
                    // Get current state of AllowUnsafeUpdates for the Site
                    var allowUnsafeUpdates = web.AllowUnsafeUpdates;

                    // Set AllowUnsafeUpdates
                    web.AllowUnsafeUpdates = true;
                    web.Update();

                    // Use the Seattle.master Master Page by default
                    var masterUrl = SeattleMasterUrl;
                    var customMasterUrl = SeattleMasterUrl;

                    // Get the old Master Page Urls from the properties set during activation,
                    // remove our custom properties if they exist
                    if (web.AllProperties.ContainsKey(PropertyOldMasterUrl))
                    {
                        // Get the property value
                        var propertyValue = web.AllProperties[PropertyOldMasterUrl] as string;

                        // If the property value is not null, set as the Master Url
                        if (!string.IsNullOrEmpty(propertyValue))
                            masterUrl = propertyValue;

                        web.AllProperties.Remove(PropertyOldMasterUrl);
                    }

                    if (web.AllProperties.ContainsKey(PropertyOldCustomMasterUrl))
                    {
                        // Get the property value
                        var propertyValue = web.AllProperties[PropertyOldCustomMasterUrl] as string;

                        // If the property value is not null, set as the Custom Master Url
                        if (!string.IsNullOrEmpty(propertyValue))
                            customMasterUrl = propertyValue;

                        web.AllProperties.Remove(PropertyOldCustomMasterUrl);
                    }

                    // Set the original master page as the Site and System Master Pages
                    web.MasterUrl = masterUrl;
                    web.CustomMasterUrl = customMasterUrl;
                    web.Update();

                    // Revert AllowUnsafeUpdates
                    web.AllowUnsafeUpdates = allowUnsafeUpdates;
                    web.Update();
                }
            }
        }
    }
}
